<?php

namespace Google\Site_Kit_Dependencies;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
class Google_Service_Analytics_WebPropertySummary extends \Google\Site_Kit_Dependencies\Google_Collection
{
    protected $collection_key = 'profiles';
    public $id;
    public $internalWebPropertyId;
    public $kind;
    public $level;
    public $name;
    protected $profilesType = 'Google\Site_Kit_Dependencies\Google_Service_Analytics_ProfileSummary';
    protected $profilesDataType = 'array';
    public $starred;
    public $websiteUrl;
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setInternalWebPropertyId($internalWebPropertyId)
    {
        $this->internalWebPropertyId = $internalWebPropertyId;
    }
    public function getInternalWebPropertyId()
    {
        return $this->internalWebPropertyId;
    }
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    public function getKind()
    {
        return $this->kind;
    }
    public function setLevel($level)
    {
        $this->level = $level;
    }
    public function getLevel()
    {
        return $this->level;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    /**
     * @param Google_Service_Analytics_ProfileSummary
     */
    public function setProfiles($profiles)
    {
        $this->profiles = $profiles;
    }
    /**
     * @return Google_Service_Analytics_ProfileSummary
     */
    public function getProfiles()
    {
        return $this->profiles;
    }
    public function setStarred($starred)
    {
        $this->starred = $starred;
    }
    public function getStarred()
    {
        return $this->starred;
    }
    public function setWebsiteUrl($websiteUrl)
    {
        $this->websiteUrl = $websiteUrl;
    }
    public function getWebsiteUrl()
    {
        return $this->websiteUrl;
    }
}
